<?php
/**
 * Amelia Booking Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Amelia Booking module class.
 */
class HelloPack_Module_Amelia_Booking extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'amelia-booking';
		$this->name        = __( 'Amelia Booking', 'hellopack-client' );
		$this->description = __( 'Manages Amelia Booking updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'ameliabooking',
			'plugin_file' => 'ameliabooking.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set Amelia license as active
		$this->set_license_active();
		
		// Override update API
		$this->override_update_api();
	}

	/**
	 * Set Amelia license as active
	 */
	private function set_license_active() {
		$option_name     = 'amelia_settings';
		$amelia_settings = get_option( $option_name );

		if ( false !== $amelia_settings ) {
			$amelia_settings_decoded = json_decode( $amelia_settings, true );
			
			// Set activation as active
			$amelia_settings_decoded['activation']['active'] = true;
			
			$amelia_settings_updated = json_encode( $amelia_settings_decoded );
			
			// Use HP_check_options if available
			if ( function_exists( 'HP_check_options' ) ) {
				HP_check_options( $option_name, $amelia_settings_updated );
			} else {
				update_option( $option_name, $amelia_settings_updated );
			}
		}
	}

	/**
	 * Override Amelia Booking update API
	 */
	private function override_update_api() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$ameliabooking = new HPack_Set_API_Servers();
			$ameliabooking->over_api_servers( 'store.tms-plugins.com/api/autoupdate/info' );
			$ameliabooking->init();
		}
	}
}