<?php
/**
 * Complianz GDPR Premium Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Complianz_GDPR_Premium
 */
class HelloPack_Module_Complianz_GDPR_Premium extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'complianz-gdpr-premium';
		$this->name        = 'Complianz GDPR Premium';
		$this->description = __( 'Manages Complianz GDPR Premium updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'complianz-gdpr-premium',
			'plugin_file' => 'complianz-gdpr-premium.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate Complianz GDPR Premium license.
	 */
	private function activate_license() {
		update_site_option( 'cmplz_license_key', 'activated' );
		update_site_option( 'cmplz_license_status', 'valid' );
		update_site_option( 'cmplz_license_activation_limit', '999' );
		update_site_option( 'cmplz_license_activations_left', '990' );
		update_site_option( 'cmplz_license_expires', 'lifetime' );
	}
}