<?php
/**
 * Divi Tools Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Divi_Tools
 */
class HelloPack_Module_Divi_Tools extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'divi-tools';
		$this->name        = 'Divi Tools';
		$this->description = __( 'Manages Divi Tools updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'divi-toolbox',
			'plugin_file' => 'divi-toolbox.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
		add_action( 'admin_menu', array( $this, 'remove_license_menu' ), 999 );
	}

	/**
	 * Activate Divi Toolbox license.
	 */
	private function activate_license() {
		HP_check_options( 'wc_am_client_6865_deactivate_checkbox', 'off' );
		HP_check_options( 'wc_am_client_6865_activated', 'Activated' );

		$wc_am_client_6865['wc_am_client_6865_api_key'] = HP_GLOBAL_SERIAL;
		HP_check_options( 'wc_am_client_6865', $wc_am_client_6865 );
	}

	/**
	 * Remove license menu from admin.
	 */
	public function remove_license_menu() {
		remove_submenu_page( 'options-general.php', 'wc_am_client_6865_dashboard' );
	}
}