<?php
/**
 * FluentForm Signature Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_FluentForm_Signature
 */
class HelloPack_Module_FluentForm_Signature extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluentform-signature';
		$this->name        = 'FluentForm Signature';
		$this->description = __( 'Manages FluentForm Signature updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluentform-signature',
			'plugin_file' => 'fluentform-signature.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
		$this->activate_license();
	}

	/**
	 * Set API servers for FluentForm Signature.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$fluentformspdf = new HPack_Set_API_Servers();
			$fluentformspdf->over_api_servers( 'apiv2.wpmanageninja.com/plugin' );
			$fluentformspdf->init();
		}
	}

	/**
	 * Activate FluentForm Signature license.
	 */
	private function activate_license() {
		HP_check_options( '_ff_signature_license_status', 'valid' );
		delete_option( '_ff_signature_license_key' );
		delete_option( '_ff_signature_license_status_checking' );
	}
}