<?php
/**
 * FluentForms PDF Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_FluentForms_PDF
 */
class HelloPack_Module_FluentForms_PDF extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluentforms-pdf';
		$this->name        = 'FluentForms PDF';
		$this->description = __( 'Manages FluentForms PDF updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluentforms-pdf',
			'plugin_file' => 'fluentforms-pdf.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
	}

	/**
	 * Set API servers for FluentForms PDF.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$fluentformspdf = new HPack_Set_API_Servers();
			$fluentformspdf->over_api_servers( 'apiv2.wpmanageninja.com/plugin' );
			$fluentformspdf->init();
		}
	}
}