<?php
/**
 * LearnDash Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * LearnDash module class.
 */
class HelloPack_Module_LearnDash extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'learndash';
		$this->name        = __( 'LearnDash LMS', 'hellopack-client' );
		$this->description = __( 'Manages LearnDash LMS updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'sfwd-lms',
			'plugin_file' => 'sfwd_lms.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Define LearnDash updates enabled
		if ( ! defined( 'LEARNDASH_UPDATES_ENABLED' ) ) {
			define( 'LEARNDASH_UPDATES_ENABLED', 'enabled' );
		}
		
		// Setup LearnDash license
		$this->setup_learndash_license();
		
		// Setup API servers
		$this->setup_api_servers();
		
		// Add admin CSS to hide various elements
		add_action( 'admin_head', array( $this, 'add_admin_css' ) );
	}

	/**
	 * Setup LearnDash license
	 */
	private function setup_learndash_license() {
		if ( defined( 'LEARNDASH_VERSION' ) ) {
			update_option( 'nss_plugin_license_email_sfwd_lms', 'support@hellowp.io' );
			update_option( 'nss_plugin_license_sfwd_lms', 'HFSS-A3CG-DAS4-HW2X' );
		}
	}

	/**
	 * Setup API servers for LearnDash
	 */
	private function setup_api_servers() {
		if ( defined( 'LEARNDASH_VERSION' ) && class_exists( 'HPack_Set_API_Servers' ) ) {
			// Checkout API
			$checkoutlearndash = new HPack_Set_API_Servers();
			$checkoutlearndash->set_api_servers( 'checkout.learndash.com/wp-json', HP_PLUGIN_API_SERVER );
			$checkoutlearndash->init();

			// Plugin update API
			$pluginupdate = new HPack_Set_API_Servers();
			$pluginupdate->set_api_servers( 'support.learndash.com/?pluginupdate', HP_PLUGIN_API_SERVER . '/learndash/v1/pluginupdate?api' );
			$pluginupdate->init();
		}
	}

	/**
	 * Add admin CSS to hide LearnDash elements
	 */
	public function add_admin_css() {
		?>
		<style>
			/* Hide LearnDash updates disabled notice */
			.learndash-updates-disabled-dismissible {
				display: none !important;
			}
			
			/* Hide course wizard button */
			a.global-new-entity-button[href="<?php echo esc_url( home_url( '/wp-admin/admin.php?page=learndash-course-wizard' ) ); ?>"] {
				display: none;
			}
		</style>
		<?php
	}
}