<?php
/**
 * Ninja Forms Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Ninja_Forms
 */
class HelloPack_Module_Ninja_Forms extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'ninja-forms';
		$this->name        = 'Ninja Forms';
		$this->description = __( 'Manages Ninja Forms updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'ninja-forms',
			'plugin_file' => 'ninja-forms.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
	}

	/**
	 * Set API servers for Ninja Forms.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$ninjaforms = new HPack_Set_API_Servers();
			$ninjaforms->over_api_servers( 'api.ninjaforms.com' );
			$ninjaforms->init();

			$ninjaforms_update = new HPack_Set_API_Servers();
			$ninjaforms_update->over_api_servers( 'ninjaforms.com/update-check' );
			$ninjaforms_update->init();

			$ninjaforms_servers = new HPack_Set_API_Servers();
			$ninjaforms_servers->over_api_servers( 'ninjaforms.com' );
			$ninjaforms_servers->init();
		}
	}
}