<?php
/**
 * QuadMenu Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * QuadMenu Pro module class.
 */
class HelloPack_Module_QuadMenu_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'quadmenu-pro';
		$this->name        = __( 'QuadMenu Pro', 'hellopack-client' );
		$this->description = __( 'Manages QuadMenu Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'quadmenu-pro',
			'plugin_file' => 'quadmenu-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Hide admin notices
		$this->hide_admin_notices();
		
		// Override API servers
		$this->override_api_servers();
		
		// Set license data
		$this->set_license_data();
		
		// Disable upgrader pre-download
		add_action( 'admin_init', 'disable_upgrader_pre_download' );
	}

	/**
	 * Hide admin notices
	 */
	private function hide_admin_notices() {
		if ( class_exists( 'HelloPackCSSDisable' ) ) {
			$qlwlm_quadmenu_notice = new HelloPackCSSDisable();
			$qlwlm_quadmenu_notice->add_selector( '#quadmenu-pro-update .notice-error' );
			$qlwlm_quadmenu_notice->hide_notices();
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$quadmenu_license = new HPack_Set_API_Servers();
			$quadmenu_license->over_api_servers( 'quadmenu.com/wp-json/wc/wlm/product/information' );
			$quadmenu_license->init();
		}
	}

	/**
	 * Set license data
	 */
	private function set_license_data() {
		$qlwlm_quadmenu_pro_user_data = array(
			'license_key'    => HP_GLOBAL_SERIAL,
			'license_email'  => 'support@hellowp.io',
			'license_client' => '',
		);

		$qlwlm_quadmenu_pro_activation = array(
			'message'              => null,
			'order_id'             => 42,
			'license_key'          => HP_GLOBAL_SERIAL,
			'license_email'        => 1,
			'license_limit'        => 0,
			'license_updates'      => 0,
			'license_support'      => 1,
			'license_expiration'   => '2028-04-21 10:40:23',
			'license_created'      => '2000-10-21 10:40:23',
			'activation_limit'     => 'Unlimited',
			'activation_count'     => 42,
			'activation_remaining' => 'Unlimited',
			'activation_instance'  => 42,
			'activation_status'    => 1,
			'activation_site'      => get_home_url(),
			'activation_created'   => '2020-02-05 17:04:58',
		);

		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'qlwlm_quadmenu-pro_user_data', $qlwlm_quadmenu_pro_user_data );
			HP_check_options( 'qlwlm_quadmenu-pro_activation', $qlwlm_quadmenu_pro_activation );
		}
	}
}