<?php
/**
 * Restrict Content Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Restrict Content Pro module class.
 */
class HelloPack_Module_Restrict_Content_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'restrict-content-pro';
		$this->name        = __( 'Restrict Content Pro', 'hellopack-client' );
		$this->description = __( 'Manages Restrict Content Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'restrict-content-pro',
			'plugin_file' => 'restrict-content-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$restrict = new HPack_Set_API_Servers();
			$restrict->over_api_servers( 'restrictcontentpro.com' );
			$restrict->init();
		}
	}
}