<?php
/**
 * HelloPack Module: WP SEOPress Pro
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_WP_SEOPress_Pro
 *
 * Module for managing WP SEOPress Pro plugin functionality
 */
class HelloPack_Module_WP_SEOPress_Pro extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'wp-seopress-pro';
		$this->name        = 'WP SEOPress Pro';
		$this->description = __( 'Manages WP SEOPress Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wp-seopress-pro',
			'plugin_file' => 'seopress-pro.php',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		if ( ! defined( 'SEOPRESS_LICENSE_KEY' ) ) {
			define( 'SEOPRESS_LICENSE_KEY', HP_GLOBAL_SERIAL );
		}

		$seopress_licensing = new HPack_Set_API_Servers();
		$seopress_licensing->set_api_servers( 'www.seopress.org', HELLOPACK_LICENSE_MANAGER_SERVER . '/universal/activate-license?s=' );
		$seopress_licensing->init();

		HP_check_options( 'seopress_pro_license_status', 'valid' );
	}
}