<?php
/**
 * HelloPack Module: Yoast Pro
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Yoast_Pro
 *
 * Module for managing Yoast Pro plugin functionality
 */
class HelloPack_Module_Yoast_Pro extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'yoast-pro';
		$this->name        = 'Yoast Pro';
		$this->description = __( 'Manages Yoast Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wordpress-seo-premium',
			'plugin_file' => 'wp-seo-premium.php',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$updates = new HPack_Set_API_Servers();
		$updates->over_api_servers( 'tracking.yoast.com/stats' );
		$updates->init();

		add_action( 'admin_head', array( $this, 'hp_morphology_disabled' ) );
	}

	/**
	 * Display morphology disabled message
	 *
	 * @return void
	 */
	public function hp_morphology_disabled() {
		echo "<style>
    #yoast-configuration-indexing-container:after {
     margin-top: 10px;
     display: block;
     color: red;
     content: 'A HelloPack nem támogatja a Morphology szolgáltatást (mivel magyarul érdemben használhatatlan), ezért a varázsló hibát fog jelezni. Semmilyen problémát nem okoz, kérlek, hogy nyugodtan nyomj a Tovább gombra, amikor jelzi a hibát.';
   }
  </style>";
	}
}