jQuery(document).ready(function($) {
    // Handle module toggle with new UI buttons
    $('.hellopack-module-toggle-wrapper .ui-button').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $buttonSet = $button.parent();
        var $row = $button.closest('tr');
        var moduleId = $button.data('module-id');
        var value = $button.data('value');
        var isEnabled = (value === 'on');
        
        // Disable buttons during request
        $buttonSet.find('.ui-button').prop('disabled', true);
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'hellopack_toggle_module',
                module_id: moduleId,
                enabled: isEnabled,
                nonce: hellopack_modules.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Update toggle buttons
                    $buttonSet.find('.ui-button').removeClass('ui-state-active');
                    $button.addClass('ui-state-active');
                    $buttonSet.siblings('.module-toggle-value').val(value);
                    
                    // Update status badge
                    var $statusBadge = $row.find('.hellopack-module-status-badge');
                    $statusBadge.find('span').remove();
                    
                    if (!isEnabled) {
                        $statusBadge.append('<span class="badge-disabled" style="color: #fff; background-color: #ff3960; padding: 4px 8px; border-radius: 4px; display: inline-block;">' + hellopack_modules.disabled_text + '</span>');
                    } else {
                        // Check if module is active or ready
                        if (response.data.is_active) {
                            $statusBadge.append('<span class="badge-active" style="color: #fff; background-color: #23d160; padding: 4px 8px; border-radius: 4px; display: inline-block;">' + hellopack_modules.active_text + '</span>');
                        } else {
                            $statusBadge.append('<span class="badge-ready" style="color: #fff; background-color: #198fd9; padding: 4px 8px; border-radius: 4px; display: inline-block;">' + hellopack_modules.ready_text + '</span>');
                        }
                    }
                    
                    // Show success notice
                    if ($('.hellopack-module-notice').length === 0) {
                        $('#modules .hellopack-db-card').first().before('<div class="notice notice-success is-dismissible hellopack-module-notice"><p>' + response.data.message + '</p></div>');
                    } else {
                        $('.hellopack-module-notice').removeClass('notice-error').addClass('notice-success').find('p').text(response.data.message);
                    }
                } else {
                    // Show error notice
                    if ($('.hellopack-module-notice').length === 0) {
                        $('#modules .hellopack-db-card').first().before('<div class="notice notice-error is-dismissible hellopack-module-notice"><p>' + response.data.message + '</p></div>');
                    } else {
                        $('.hellopack-module-notice').removeClass('notice-success').addClass('notice-error').find('p').text(response.data.message);
                    }
                }
            },
            error: function() {
                alert(hellopack_modules.error_text);
            },
            complete: function() {
                $buttonSet.find('.ui-button').prop('disabled', false);
            }
        });
    });
});